<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // ইউজার লগইন আছে এবং is_admin ফিল্ড true হলে
        if (Auth::check() && Auth::user()->is_admin) {
            return $next($request);
        }

        // নাহলে 403 Forbidden রেসপন্স দিন
        abort(403, 'Unauthorized');
    }
}
