@extends('layouts.app') 
@section('title') {{ __('My Account') }} {{ __('-') }} {{ $settings->site_title }} 
@endsection 
@section('content')
<!--- acoount page--->
<div>
  <div class="p-2">
    <div class="text-center">
      <button>
        <img src="{{auth()->user()->avator}}" class="user_style_profile">
      </button>
    </div>
    <div class="text-center w-full">
      <span class="capitalize mt-1 theme-color-text font-16">Hi, {{ $name }}</span>
    </div>
    <div class="text-center w-full flex mb-3 md:mb-8 justify-center items-center">
      <span class="capitalize primary-font-color-text font-16">
        <b class="font-bold">Available Balance :  {{ price($balance) }}</b>
      </span>
      <div class="border ml-2 p-1 rounded cursor-pointer">
        <svg viewBox="0 0 24 24" style="width: 16px; height: 16px;">
          <path fill="currentColor" d="M2 12C2 16.97 6.03 21 11 21C13.39 21 15.68 20.06 17.4 18.4L15.9 16.9C14.63 18.25 12.86 19 11 19C4.76 19 1.64 11.46 6.05 7.05C10.46 2.64 18 5.77 18 12H15L19 16H19.1L23 12H20C20 7.03 15.97 3 11 3C6.03 3 2 7.03 2 12Z"></path>
        </svg>
      </div>
    </div>
    <div style="max-width: 700px; margin: auto;">
      <div class="text-center grid md:grid-cols-4 grid-cols-2 md:gap-4 gap-3 my-2 md:my-5 mb-10 statics-container">
        <div class="bg-white statics">
          <h2 class="text-lg font-normal fb-normal statics-heading">{{ price($balance) }}</h2>
          <h2 class="text-lg primary-font-color-text font-normal fb-normal">{{ __('Balance') }}</h2>
        </div>
        <div class="bg-white statics">
          <h2 class="text-lg font-normal fb-normall statics-heading">{{ $totalOrder }}</h2>
          <h2 class="text-lg primary-font-color-text font-normal fb-normal">{{ __('Total Order') }}</h2>
        </div>
        <div class="bg-white statics">
          <h2 class="text-lg font-normal fb-normall statics-heading">{{ price($totalSpent) }}</h2>
          <h2 class="text-lg primary-font-color-text font-normal fb-normal">{{ __('Total Spent') }}</h2>
        </div>
        <div class="bg-white statics">
          <h2 class="text-lg font-normal fb-normall statics-heading">5433</h2>
          <h2 class="text-lg primary-font-color-text font-normal fb-normal">{{ __('Support PIN') }}</h2>
        </div>
      </div>

      <div class="bg-white border rounded-md">
          <div class="text-left px-3 flex items-center">
            <svg class="mr-2 w-6" viewbox="0 0 24 24">
            <path fill="currentColor" d="M21 11.1V8C21 6.9 20.1 6 19 6H11L9 4H3C1.9 4 1 4.9 1 6V18C1 19.1 1.9 20 3 20H10.2C11.4 21.8 13.6 23 16 23C19.9 23 23 19.9 23 16C23 14.1 22.2 12.4 21 11.1M9.3 18H3V8H19V9.7C18.1 9.2 17.1 9 16 9C12.1 9 9 12.1 9 16C9 16.7 9.1 17.4 9.3 18M16 21C13.2 21 11 18.8 11 16S13.2 11 16 11 21 13.2 21 16 18.8 21 16 21M17 14H15V12H17V14M17 20H15V15H17V20Z"></path></svg>
            <h2 class="text-lg text-black py-2 font-normal fb">Account Information</h2>
          </div>    
          <hr>
          <div class="p-2">
            <div class="grid md:grid-cols-2 grid-cols-1 md:gap-8 gap-4">
              <div class="border w-64 mx-auto p-3 text-center">
                <div class="text-center font-primary">
                  <button type="button" class="justify-center focus:outline-none disabled:cursor-not-allowed disabled:opacity-75 flex-shrink-0 font-medium rounded-md text-sm gap-x-1.5 px-2.5 py-2.5 shadow-sm text-white dark:text-gray-900 bg-pink-500 hover:bg-primary-600 disabled:bg-pink-500 dark:bg-primary-400 dark:hover:bg-primary-500 dark:disabled:bg-primary-400 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-500 dark:focus-visible:outline-primary-400 inline-flex items-center my-2 w-full text-center">{{ price($balance) }}</button>
                </div>
                <h5 class="text-2xl font-bold fb-normal mt-3">Available Balance</h5>
              </div>
              <div class="border w-64 mx-auto p-3 text-center">
                <div class="text-center">
                  <div class="text-center">
                    <svg class="mx-auto" viewbox="0 0 24 24" style="width: 40px; height: 40px; color: rgb(31, 120, 255);">
                    <path fill="currentColor" d="M23,12L20.56,9.22L20.9,5.54L17.29,4.72L15.4,1.54L12,3L8.6,1.54L6.71,4.72L3.1,5.53L3.44,9.21L1,12L3.44,14.78L3.1,18.47L6.71,19.29L8.6,22.47L12,21L15.4,22.46L17.29,19.28L20.9,18.46L20.56,14.78L23,12M10,17L6,13L7.41,11.59L10,14.17L16.59,7.58L18,9L10,17Z"></path></svg>
                    <h5 class="text-2xl font-bold fb-normal mt-3">Account Verified!</h5>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
    </div>
  </div>
</div>
<hr>
        <div class="px-4 py-2"> @error('phone') <div class="alert alert-white" role="alert">{{ $message }}</div> @enderror <form method="POST" action="{{ route('user.account.update') }}"> @csrf <label for="email" class="control-label">{{ __('Email') }}</label>
            <input type="text" class="form-control shadow" name="email" value="{{ old('email', $user->email) }}" required> @error('email') <div class="alert alert-white" role="alert">{{ $message }}</div> @enderror <label for="phone" class="control-label">{{ __('Phone Number') }}</label>
            <input type="text" class="form-control shadow" name="phone" value="{{ old('phone', $user->phone) }}" required> @error('phone') <div class="alert alert-white" role="alert">{{ $message }}</div> @enderror <div class="clearfix" align="center">
              <input type="submit" class="btn theme-btn-block shadow" value="Update">
            </div>
          </form>
        </div>
      </div>
@endsection
