<?php

namespace RtRasel\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Constants\Installer;
use RtRasel\LaravelInstaller\Helpers\PermissionsChecker;

class PermissionsController extends Controller
{
    /**
     * @var PermissionsChecker
     */
    protected $permissions;

    /**
     * @param  PermissionsChecker  $checker
     */
    public function __construct(PermissionsChecker $checker)
    {
        $this->permissions = $checker;
    }

    /**
     * Display the permissions check page.
     *
     * @return \Illuminate\View\View
     */
    public function permissions()
    {
        if(!session('requirements')){
            return redirect()->back();
        }

        $permissions = $this->permissions->check(
            Installer::CONFIG['permissions']
        );

        if ( ! isset($permissions['errors'])){
            session()->put('permissions', true);
        }

        return view('laravelinstaller::permissions', compact('permissions'));
    }
}
